#include <iostream>
#include <iomanip>
#include <string>
#include "engine.h"
#include "board.h"
#include "squares.h"
#include "piece.h"
#include "log.h"
#include "fen.h"
#include "make.h"
#include "movegen.h"
#include "attack.h"


using namespace std;

void cEngine::initucioptions()
{
    options.ponder  = false;
}

void cEngine::sayversion()
{
	cout<<"id name Jabba 1.0\n"<<endl;
	cout<<"id author Richard Allbert\n"<<endl;
    tree.uci = true;
    tree.xb = false;
	fflush(stdout);
}

void cEngine::process_uci()
{
	setbuf(stdout, NULL);
    setbuf(stdout, NULL);
    setvbuf(stdin, NULL, _IONBF, 0);
    setvbuf(stdout, NULL, _IONBF, 0);

	string input;

	initucioptions();
    sayversion();
	sayucioptions();
	cout<<"uciok\n";

	int pos;
	while(getline(cin, input))
	{
	  fflush(stdout);

	 if(findsubstr("uci", input, pos))
	 {
	  sayversion();
	  sayucioptions();
	  cout<<"uciok\n";
	  continue;
	 }
	 else if(findsubstr("isready", input, pos))
	 {
	  cout<<"readyok\n";
	  continue;
	 }
	 else if(findsubstr("quit", input, pos))
	 {
	 	return;
	 }
	 else if(findsubstr("ucinewgame", input, pos))
	 {
	 	continue;
	 }
	 else if(findsubstr("position", input, pos))
	 {
	 	uciposition(input);
		continue;
	 }
	 else if(findsubstr("setoption", input, pos))
	 {
         setucioptions(input);
         continue;
	 }
	 else if(findsubstr("go", input, pos))
	 {
		 uci_go(input);
		 continue;
	 }
	 else if(findsubstr("eval", input, pos))
	 {
		 cout<<"\n eval score: "<<tree.scorer.eval(tree.game, tree.mat, tree.ptab);
		 cout<<endl;
		 continue;
	 }
	 else if(findsubstr("print", input, pos))
	 {
		 tree.game.printboard();
		 cout<<endl;
		 continue;
	 }
	 else
	 {
	  cout<<"unknown command "<<input<<endl;
	  continue;
	 }
	}
}

void cEngine::uciposition(string line)
{

	int start = line.find("startpos");
	int fen = line.find("fen ");
	if (start!=-1) //we have a startpos command
	{
        setepdposition(startfen,tree.game,tree.mat, tree.his);
	}
	else if(fen!=-1)
	{
		//erase the "position fen " part to send the position string
		line.erase(0, fen+4);
		setepdposition(line,tree.game,tree.mat, tree.his);
	}
	else
	{
		cout<<"\n error - not starting position defined \n";
		return;
	}

	if(line.find("moves ")==-1) return; // no moves
    line.erase(0, line.find("moves ")+6);
	string move;
	string::iterator pline = line.begin();

    while ( pline != line.end() )
    {
    	if ( *pline == ' ' )
		{
			if(!parse_move(move)) {cout<<" ERROR parsing "<<move;return;}
			move.clear();
			*pline++;
			continue;
		}
		move+=*pline;
		*pline++;
    }

	if(!parse_move(move)) {cout<<" ERROR parsing "<<move;return;}

	tree.game.printboard();
	cout<<endl;

	return;
}



void cEngine::init_go()
{
          tree.timer.resettimeparam(cW);
	      tree.timer.resettimeparam(cB);
}


void cEngine::uci_go(string command)
{
	init_go();

	string input;
	int pos;

	 if(findsubstr("depth", command, pos))
	 {
		  tree.timer.setdepth(strtoint(command, pos+6));
          tree.timer.setmodetpm(false);
          tree.timer.setmodemtg(false);
          tree.timer.setdepthlimit(true);
          #ifdef DEBUG
		  cout<<" set depth to "<<tree.timer.getdepth()<<endl;
		  #endif
	 }
	 if(findsubstr("movetime", command, pos))
	 {
		  tree.timer.settimepermove(strtoint(command, pos+9));
          tree.timer.setmodetpm(true);
          tree.timer.setmodemtg(false);
          tree.timer.setdepthlimit(false);
          tree.timer.setdepth(maxply);
	 }
	 if(findsubstr("infinite", command, pos))
	 {
	     tree.setmode(smINFINITE);
	 }
	 if(findsubstr("wtime", command, pos))
	 {
	     tree.timer.setmovetime(strtoint(command, pos+6), cW);
	     tree.timer.setmodetpm(false);
         tree.timer.setdepth(maxply);
	 }
	 if(findsubstr("btime", command, pos))
	 {
	     tree.timer.setmovetime(strtoint(command, pos+6), cB);
	     tree.timer.setmodetpm(false);
         tree.timer.setdepth(maxply);
	 }
	 if(findsubstr("winc", command, pos))
	 {
	     tree.timer.setinc(strtoint(command, pos+5),cW);
	 }
	 if(findsubstr("binc", command, pos))
	 {
	     tree.timer.setinc(strtoint(command, pos+5),cW);
	 }
	 if(findsubstr("ponder", command, pos))
	 {
	     tree.setmode(smPONDER);
	 }
	 if(findsubstr("movestogo", command, pos))
	 {
	    tree.timer.setmovestogo(strtoint(command, pos+10),tree.game.getside());
        tree.timer.setmodemps(strtoint(command, pos+10));
	 }

	 if(logger.islog())
     {
	   logger.file <<"Jabba entering think \nmovestogo "<<tree.timer.getmovestogo(cW)<<"(w) "<<tree.timer.getmovestogo(cB)<<"(b)";
	   logger.file <<"\ndepth "<<tree.timer.getdepth();
	   logger.file <<"\nwtime "<<tree.timer.getmovetime(cW);
	   logger.file <<"\nbtime "<<tree.timer.getmovetime(cB);
	   logger.file <<"\nmovetime "<<tree.timer.gettimepermove()<<"\n";
     }

	  tree.compute();
	  uint best = tree.getbestmove();
      tree.setmode(smNONE);
#ifdef DEBUG
	  tree.game.logboard();
#endif
      if(logger.islog())
      {
          logger.file <<"out of compute, bestmove "<<printmove(best);
          logger.file <<" ponder "<<printmove(tree.getpondermove())<<endl;
      }
	  fflush(stdout);
	  cout<<"\nbestmove "<<printmove(tree.getbestmove());
	  if(options.ponder)
	  {
	   cout<<" ponder "<<printmove(tree.getpondermove());
	   tree.setmode(smNONE);
	  }
	  cout<<endl;
	  fflush(stdout);
	  logger.file.flush();
}


void cEngine::sayucioptions()
{
    cout<<"option name Hash type spin default 32 min 16 max 1024\n";
    cout<<"option name Ponder type check default false\n";
}

void cEngine::setucioptions(string input)
{
    int pos;
    string sub;
    uint temp;
    if(findsubstr("setoption name Hash value ", input, pos))
    {
        sub =  "setoption name Hash value ";
        temp = strtoint(input,sub.length());
        if(temp> 1024) temp = 1024;
        if(temp < 16) temp = 16;
        tree.ttable.delete_tables();
        tree.ttable.makenewtable(temp);
    }
    else if(findsubstr("setoption name Ponder value ", input, pos))
    {
        if(findsubstr("true", input, pos)) options.ponder = true;
        else if(findsubstr("false", input, pos)) options.ponder = false;
    }/*
    if(findsubstr("setoption name psqt value ", input, pos))
    {
		if(findsubstr("true", input, pos))  tree.scorer.setpsqt(true);
        else if(findsubstr("false", input, pos)) tree.scorer.setpsqt(false);
    }
	if(findsubstr("setoption name bishops value ", input, pos))
    {
		if(findsubstr("true", input, pos))  tree.scorer.setbishops(true);
        else if(findsubstr("false", input, pos)) tree.scorer.setbishops(false);
    }
	if(findsubstr("setoption name knights value ", input, pos))
    {
		if(findsubstr("true", input, pos))  tree.scorer.setknights(true);
        else if(findsubstr("false", input, pos)) tree.scorer.setknights(false);
    }
	if(findsubstr("setoption name pawns value ", input, pos))
    {
		if(findsubstr("true", input, pos))  tree.scorer.setpawns(true);
        else if(findsubstr("false", input, pos)) tree.scorer.setpawns(false);
    }
    else if(findsubstr("setoption name Aspiration value ", input, pos))
    {
        if(findsubstr("true", input, pos)) UciOpt->aspiration = true;
        else if(findsubstr("false", input, pos)) UciOpt->aspiration = false;
    }
    else if(findsubstr("setoption name Qprune value ", input, pos))
    {
        if(findsubstr("true", input, pos)) UciOpt->qprune = true;
        else if(findsubstr("false", input, pos)) UciOpt->qprune = false;
    }
    else if(findsubstr("setoption name Nullmove value ", input, pos))
    {
        if(findsubstr("true", input, pos)) UciOpt->nullmove = true;
        else if(findsubstr("false", input, pos)) UciOpt->nullmove = false;
    }
    else if(findsubstr("setoption name IID value ", input, pos))
    {
        if(findsubstr("true", input, pos)) UciOpt->IID = true;
        else if(findsubstr("false", input, pos)) UciOpt->IID = false;
    }

    else if(findsubstr("setoption name Clearhash", input, pos))  reset_tables();
*/
    fflush(stdout);
}

